% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TreeQuartetDist.R
\name{quartetWeightedDist}
\alias{quartetWeightedDist}
\title{Compute the Weighted Quartet Distance between taxa}
\usage{
quartetWeightedDist(dqt)
}
\arguments{
\item{dqt}{an (\code{n} choose 4) x (\code{n+1}) matrix of the form output by \code{quartetTableDominant}}
}
\value{
a pairwise distance matrix on \code{n} taxa
}
\description{
Compute the Weighted Quartet Distance between taxa of \insertCite{YR19;textual}{MSCquartets} from a table specifying a collection of quartets on
\code{n} taxa and the quartets' internal branch lengths.
}
\examples{
gtrees=read.tree(file=system.file("extdata","dataGeneTreeSample",package="MSCquartets"))
tnames=taxonNames(gtrees)
QT=quartetTable(gtrees,tnames[1:6])
RQT=quartetTableResolved(QT)
DQT=quartetTableDominant(RQT,bigweights="finite")
D=quartetWeightedDist(DQT)
tree=NJ(D)
stree=WQDSAdjustLengths(tree)
write.tree(stree)

}
\references{
\insertRef{YR19}{MSCquartets}
}
\seealso{
\code{\link{quartetTableDominant}},
          \code{\link{WQDSAdjustLengths}},
          \code{\link{WQDS}},
          \code{\link{WQDC}}, 
          \code{\link{WQDCrecursive}},
          \code{\link{quartetWeightedDist}}
}
