% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_mexico_literacy_rate.R
\name{get_mexico_literacy_rate}
\alias{get_mexico_literacy_rate}
\title{Get Mexico's Literacy Rate (Age 15+) from World Bank}
\usage{
get_mexico_literacy_rate()
}
\value{
A tibble with the following columns:
\itemize{
  \item \code{indicator}: Indicator name (e.g., "Literacy rate, adult total (% of people ages 15 and above)").
  \item \code{country}: Country name ("Mexico").
  \item \code{year}: Year of the data.
  \item \code{value}: Literacy rate (numeric percentage).
}
}
\description{
This function retrieves Mexico's literacy rate for adults aged 15 and above,
expressed as a percentage, for the years 2010 to 2022 using the World Bank Open Data API.
The indicator used is \code{SE.ADT.LITR.ZS}.
}
\note{
Some years may return missing values (`NA`) due to lack of official data reported to the World Bank.
Requires internet connection. The function pulls data in real time from the World Bank API.
}
\examples{
\dontrun{
get_mexico_literacy_rate()
}

}
\seealso{
\code{\link[httr]{GET}}, \code{\link[jsonlite]{fromJSON}}, \code{\link[dplyr]{as_tibble}}
}
