% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dada_phyloseq.R
\name{verify_pq}
\alias{verify_pq}
\title{Verify the validity of a phyloseq object}
\usage{
verify_pq(
  physeq,
  verbose = FALSE,
  min_nb_seq_sample = 500,
  min_nb_seq_taxa = 1
)
}
\arguments{
\item{physeq}{(required): a \code{\link[phyloseq]{phyloseq-class}} object obtained
using the \code{phyloseq} package.}

\item{verbose}{(logical, default FALSE) If TRUE, prompt some warnings.}

\item{min_nb_seq_sample}{(numeric) Only used if verbose = TRUE.
Minimum number of sequences per samples to not show warning.}

\item{min_nb_seq_taxa}{(numeric) Only used if verbose = TRUE.
Minimum number of sequences per taxa to not show warning.}
}
\value{
Nothing if the phyloseq object is valid. An error in the other case.
Warnings if verbose = TRUE
}
\description{
\if{html}{\out{
<a href="https://adrientaudiere.github.io/MiscMetabar/articles/Rules.html#lifecycle">
<img src="https://img.shields.io/badge/lifecycle-maturing-blue" alt="lifecycle-maturing"></a>
}}


Mostly for internal use in MiscMetabar functions.
}
