% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Dendrograma_NumeroOtimo.R
\name{Dendrograma_NumeroOtimo}
\alias{Dendrograma_NumeroOtimo}
\title{Determinacao do numero otimo de clusters no dendrograma}
\usage{
Dendrograma_NumeroOtimo(Dissimilaridade,Metodo=3)
}
\arguments{
\item{Dissimilaridade}{Objeto criado pela funcao `Distancia`}

\item{Metodo}{Metodo Valor numerico indicando o metodo a ser utilizado:
 \itemize{
\item  1 = Ligacao simples (Metodo do vizinho mais proximo).
\item  2 = Ligacao completa (Metodo do vizinho distante).
 \item  3 = Ligacao media entre grupo (UPGMA).
 \item  4 = Metodo de Ward.
 \item  5 = Metodo de Ward (d2).
 \item  6 = Metodo da mediana (WPGMC).
 \item  7 = Metodo do centroide (UPGMC).
 \item  8 = Metodo mcquitty (WPGMA).
 }}
}
\value{
A funcao retorna o numero otimo de Clusters.
}
\description{
Esta funcao retorna informacoes que auxilia na determinacao do numero de clusters
a serem considerados no dendrograma.
}
\examples{
data(Dados.MED)
rownames(Dados.MED)=paste0("Treatment ",1:10)
Dist=Distancia(Dados.MED,Metodo=3)
Dendrograma_NumeroOtimo(Dissimilaridade = Dist,Metodo = 3)

data("Dados.CAT")
Diss=Distancia(Dados = Dados.CAT,Metodo=10)
Dendrograma_NumeroOtimo(Dissimilaridade = Diss,Metodo = 5)
}
\references{
PlayList "Curso de Analise Multivariada":
 https://www.youtube.com/playlist?list=PLvth1ZcREyK72M3lFl7kBaHiVh5W53mlR


CRUZ, C.D. and CARNEIRO, P.C.S.  Modelos biometricos aplicados ao
  melhoramento genetico. 3nd Edition. Vicosa, UFV, v.2, 2014. 668p.  (ISBN: 8572691510)

FERREIRA, D.F. Estatistica Multivariada. (2018) 3ed. UFLA. 624p. (ISBN 13:978 8581270630)

 HAIR, J.F. Multivariate Data Analysis.  (2016) 6ed. Pearson Prentice HalL.
  (ISBN 13:978 0138132637)
}
\seealso{
\code{\link{Kmeans}}, \code{\link{Tocher}} , \code{\link{Dendrograma}}
}
