% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/specificity.R
\name{specificity}
\alias{specificity}
\title{Specificity}
\usage{
specificity(
  x,
  condition,
  test.condition = NULL,
  null.condition = NULL,
  combination.size = NULL,
  upsample = TRUE
)
}
\arguments{
\item{x}{A binary matrix, with AUs as \code{colnames}, or an object of class
\code{\link{netfacs}}}

\item{condition}{A character condition vector}

\item{test.condition}{A string, denoting the test condition. If \code{NULL}
(default) specificity is calculated for all conditions.}

\item{null.condition}{A string, denoting the null condition. If \code{NULL}
(default) all observations not part of the test.condition will be
considered part of the null.}

\item{combination.size}{A positive integer, indicating the maximum
combination size of element combinations. If \code{NULL} (default), the
maximum combination size observed in the x is used.}

\item{upsample}{Logical. Should minority condition(s) be
\code{\link{upsample}}d? \code{TRUE} by default.}
}
\value{
A data frame
}
\description{
Calculate specificity of element combinations to a given condition
}
\details{
Specificity values are biased when the number of observations per
  condition is highly imbalanced. When \code{upsample} = \code{TRUE}
  (recommended), the condition(s) with fewer observations are randomly
  \code{\link{upsample}}d to match the number of observations in the most
  common condition prior to the specificity calculation. This procedure
  minimizes the bias in the specificity results.
}
\examples{
specificity(
  x = emotions_set[[1]],
  condition = emotions_set[[2]]$emotion,
  test.condition = "anger"
)
}
