% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/netint.R
\name{UA.int}
\alias{UA.int}
\title{Unweighted Average (UA) network integration}
\usage{
UA.int(align = TRUE, ...)
}
\arguments{
\item{align}{logical. If TRUE (def.) the matrices are aligned using
align.networks, otherwise they are directly summed without any
previous alignment.}

\item{...}{a list of numeric matrices. These must be named matrices
representing adjacency matrices of the networks. Matrices may have
different dimensions, but corresponding elements in different matrices
must have the same name.}
}
\value{
the integrated matrix : the matrix resulting from UA.
}
\description{
It performs the unweighted average integration between networks:
\loadmathjax
\mjsdeqn{\bar{w}_{ij} = \frac{1}{n} \sum_{d = 1}^n w_{ij}^d}
}
\examples{
# Create three example networks of different size
set.seed(123);
A1 <- matrix(runif(100, min = 0, max = 1), nrow = 10);
A1[lower.tri(A1)] = t(A1)[lower.tri(A1)];
diag(A1) <- 0;
rownames(A1) <- colnames(A1) <- sample(LETTERS, 10);

A2 <- matrix(runif(49, min = 0, max = 1), nrow = 7);
A2[lower.tri(A2)] = t(A2)[lower.tri(A2)];
diag(A2) <- 0;
rownames(A2) <- colnames(A2) <- rownames(A1)[1:7];

A3 <- matrix(runif(100, min = 0, max = 1), nrow = 10);
A3[lower.tri(A3)] = t(A3)[lower.tri(A3)];
diag(A3) <- 0;
rownames(A3) <- colnames(A3) <- c(rownames(A1)[1:5], c("A", "B", "Z", "K", "Q"));

# Integrate networks using Unweighted Average (UA) method
A_int <- UA.int(align=TRUE, A1, A2, A3);
}
