% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/002-pk.business.rules.R
\name{geomean}
\alias{geomean}
\alias{geosd}
\alias{geocv}
\title{Compute the geometric mean, sd, and CV}
\usage{
geomean(x, na.rm = FALSE)

geosd(x, na.rm = FALSE)

geocv(x, na.rm = FALSE)
}
\arguments{
\item{x}{A vector to compute the geometric mean of}

\item{na.rm}{Should missing values be removed?}
}
\value{
The scalar value of the geometric mean, geometric standard deviation,
or geometric coefficient of variation.
}
\description{
Compute the geometric mean, sd, and CV
}
\section{Functions}{
\itemize{
\item \code{geosd()}: Compute the geometric standard deviation, \code{exp(sd(log(x)))}.

\item \code{geocv()}: Compute the geometric coefficient of variation,
\code{sqrt(exp(sd(log(x))^2)-1)*100}.

}}
\examples{
geomean(1:3)
geosd(1:3)
geocv(1:3)
}
\references{
Kirkwood T. B.L. Geometric means and measures of dispersion.
Biometrics 1979; 35: 908-909
}
