% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ZIPLN.R
\name{ZIPLN}
\alias{ZIPLN}
\title{Zero Inflated Poisson lognormal model}
\usage{
ZIPLN(
  formula,
  data,
  subset,
  zi = c("single", "row", "col"),
  control = ZIPLN_param()
)
}
\arguments{
\item{formula}{an object of class "formula": a symbolic description of the model to be fitted.}

\item{data}{an optional data frame, list or environment (or object coercible by as.data.frame to a data frame) containing the variables in the model. If not found in data, the variables are taken from environment(formula), typically the environment from which PLN is called.}

\item{subset}{an optional vector specifying a subset of observations to be used in the fitting process.}

\item{zi}{a character describing the model used for zero inflation, either of
\itemize{
\item "single" (default, one parameter shared by all counts)
\item "col" (one parameter per variable / feature)
\item "row" (one parameter per sample / individual).
If covariates are specified in the formula RHS (see details) this parameter is ignored.
}}

\item{control}{a list-like structure for controlling the optimization, with default generated by \code{\link[=ZIPLN_param]{ZIPLN_param()}}. See the associated documentation
for details.}
}
\value{
an R6 object with class \code{\link{ZIPLNfit}}
}
\description{
Fit the multivariate Zero Inflated Poisson lognormal model with a variational algorithm. Use the (g)lm syntax for model specification (covariates, offsets, subset).
}
\details{
Covariates for the Zero-Inflation parameter (using a logistic regression model) can be specified in the formula RHS using the pipe
(\verb{~ PLN effect | ZI effect}) to separate covariates for the PLN part of the model from those for the Zero-Inflation part.
Note that different covariates can be used for each part.
}
\examples{
data(trichoptera)
trichoptera <- prepare_data(trichoptera$Abundance, trichoptera$Covariate)
## Use different models for zero-inflation...
myZIPLN_single <- ZIPLN(Abundance ~ 1, data = trichoptera, zi = "single")
\dontrun{
myZIPLN_row    <- ZIPLN(Abundance ~ 1, data = trichoptera, zi = "row")
myZIPLN_col    <- ZIPLN(Abundance ~ 1, data = trichoptera, zi = "col")
## ...including logistic regression on covariates
myZIPLN_covar  <- ZIPLN(Abundance ~ 1 | 1 + Wind, data = trichoptera)
}
}
\seealso{
The class \code{\link{ZIPLNfit}}
}
