% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/A01-estimator-weibull.R
\name{compute_etau}
\alias{compute_etau}
\title{Survival Effect Estimation with Weibull Censoring Scores}
\usage{
compute_etau(
  estimand,
  method,
  ps_matrix,
  n_levels,
  att_group = NULL,
  treatment_levels = NULL
)
}
\arguments{
\item{estimand}{Estimand type ("ATE", "ATT", or for overlap).}

\item{method}{Method ("IPW" or "overlap").}

\item{ps_matrix}{Propensity score matrix [n x J].}

\item{n_levels}{Number of treatment levels.}

\item{att_group}{Target group for ATT (if applicable).}

\item{treatment_levels}{Vector of treatment levels.}
}
\value{
Numeric scalar Etau.
}
\description{
Implements Estimator I (AJE 2022, Eq. 2) combining propensity score weighting
and inverse probability of censoring weighting to estimate counterfactual
survival functions and treatment effects.
Compute Etau Normalization Constant
}
\keyword{internal}
