% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PopulationSettings.R
\name{createStudyPopulationSettings}
\alias{createStudyPopulationSettings}
\title{create the study population settings}
\usage{
createStudyPopulationSettings(
  binary = TRUE,
  includeAllOutcomes = TRUE,
  firstExposureOnly = FALSE,
  washoutPeriod = 0,
  removeSubjectsWithPriorOutcome = TRUE,
  priorOutcomeLookback = 99999,
  requireTimeAtRisk = TRUE,
  minTimeAtRisk = 364,
  riskWindowStart = 1,
  startAnchor = "cohort start",
  riskWindowEnd = 365,
  endAnchor = "cohort start",
  restrictTarToCohortEnd = FALSE
)
}
\arguments{
\item{binary}{Forces the outcomeCount to be 0 or 1 (use for binary prediction problems)}

\item{includeAllOutcomes}{(binary) indicating whether to include people with outcomes who are not observed for the whole at risk period}

\item{firstExposureOnly}{Should only the first exposure per subject be included? Note that
this is typically done in the \code{createStudyPopulation} function,}

\item{washoutPeriod}{The mininum required continuous observation time prior to index
date for a person to be included in the cohort.}

\item{removeSubjectsWithPriorOutcome}{Remove subjects that have the outcome prior to the risk window start?}

\item{priorOutcomeLookback}{How many days should we look back when identifying prior outcomes?}

\item{requireTimeAtRisk}{Should subject without time at risk be removed?}

\item{minTimeAtRisk}{The minimum number of days at risk required to be included}

\item{riskWindowStart}{The start of the risk window (in days) relative to the index date (+
days of exposure if the \code{addExposureDaysToStart} parameter is
specified).}

\item{startAnchor}{The anchor point for the start of the risk window. Can be "cohort start" or "cohort end".}

\item{riskWindowEnd}{The end of the risk window (in days) relative to the index data (+
days of exposure if the \code{addExposureDaysToEnd} parameter is
specified).}

\item{endAnchor}{The anchor point for the end of the risk window. Can be "cohort start" or "cohort end".}

\item{restrictTarToCohortEnd}{If using a survival model and you want the time-at-risk to end at the cohort end date set this to T}
}
\value{
An object of type populationSettings containing all the settings required
for creating the study population
}
\description{
create the study population settings
}
\examples{
# Create study population settings with a washout period of 30 days and a 
# risk window of 1 to 90 days
populationSettings <- createStudyPopulationSettings(washoutPeriod = 30, 
                                                    riskWindowStart = 1,
                                                    riskWindowEnd = 90)
}
