% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ExtractData.R
\name{getPlpData}
\alias{getPlpData}
\title{Extract the patient level prediction data from the server}
\usage{
getPlpData(databaseDetails, covariateSettings, restrictPlpDataSettings = NULL)
}
\arguments{
\item{databaseDetails}{The cdm database details created using \code{createDatabaseDetails()}}

\item{covariateSettings}{An object of type \code{covariateSettings} or a list of such objects as created using the
\code{createCovariateSettings} function in the
\code{FeatureExtraction} package.}

\item{restrictPlpDataSettings}{Extra settings to apply to the target population while extracting data.
Created using \code{createRestrictPlpDataSettings()}. This is optional.}
}
\value{
'r plpDataObjectDoc()`
}
\description{
This function executes a large set of SQL statements against the database in OMOP CDM format to
extract the data needed to perform the analysis.
}
\details{
Based on the arguments, the at risk cohort data is retrieved, as well as outcomes
occurring in these subjects. The at risk cohort is identified  through
user-defined cohorts in a cohort table either inside the CDM instance or in a separate schema.
Similarly, outcomes are identified
through user-defined cohorts in a cohort table either inside the CDM instance or in a separate
schema. Covariates are automatically extracted from the appropriate tables within the CDM.
If you wish to exclude concepts from covariates you will need to
manually add the concept_ids and descendants to the \code{excludedCovariateConceptIds} of the
\code{covariateSettings} argument.
}
\examples{
\dontshow{if (rlang::is_installed("Eunomia") && rlang::is_installed("curl") && curl::has_internet()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
\donttest{ \dontshow{ # takes too long }
 # use Eunomia database
 connectionDetails <- Eunomia::getEunomiaConnectionDetails()
 Eunomia::createCohorts(connectionDetails)
 outcomeId <- 3 # GIbleed
 databaseDetails <- createDatabaseDetails(
   connectionDetails = connectionDetails,
   cdmDatabaseSchema = "main",
   cdmDatabaseName = "main",
   cohortDatabaseSchema = "main",
   cohortTable = "cohort",
   outcomeDatabaseSchema = "main",
   outcomeTable = "cohort",
   targetId = 1,
   outcomeIds = outcomeId,
   cdmVersion = 5
 )

 covariateSettings <- FeatureExtraction::createCovariateSettings(
   useDemographicsAge = TRUE,
   useDemographicsGender = TRUE,
   useConditionOccurrenceAnyTimePrior = TRUE
 )

 plpData <- getPlpData(
   databaseDetails = databaseDetails,
   covariateSettings = covariateSettings,
   restrictPlpDataSettings = createRestrictPlpDataSettings()
 )
}
\dontshow{\}) # examplesIf}
}
