% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SaveLoadPlp.R
\name{savePlpModel}
\alias{savePlpModel}
\title{Saves the plp model}
\usage{
savePlpModel(plpModel, dirPath)
}
\arguments{
\item{plpModel}{A trained classifier returned by running \code{runPlp()$model}}

\item{dirPath}{A location to save the model to}
}
\value{
\if{html}{\out{<div class="sourceCode">}}\preformatted{                    The directory path where the model was saved
}\if{html}{\out{</div>}}
}
\description{
Saves the plp model
}
\details{
Saves the plp model to a user specificed folder
}
\examples{
\donttest{ \dontshow{ # takes too long }
data("simulationProfile")
plpData <- simulatePlpData(simulationProfile, n = 1000)
saveLoc <- file.path(tempdir(), "savePlpModel")
plpResult <- runPlp(plpData, outcomeId = 3, saveDirectory = saveLoc)
path <- savePlpModel(plpResult$model, file.path(saveLoc, "savedModel"))
# show the saved model
dir(path, full.names = TRUE)

# clean up
unlink(saveLoc, recursive = TRUE)
}
}
