% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_independent_expenditure_by_date.R
\name{get_independent_expenditure_by_date}
\alias{get_independent_expenditure_by_date}
\title{Get Independent Expenditures by Date}
\usage{
get_independent_expenditure_by_date(cycle = 2018, year, month, day,
  myAPI_Key)
}
\arguments{
\item{cycle}{The election cycle}

\item{year}{The four-digit year from 2008-2016}

\item{month}{The two-digit month from 01-12}

\item{day}{The two-digit day from 01-31}

\item{myAPI_Key}{API key from Propublica To use the congress API, you must sign up for an API key.}
}
\value{
List of returned JSON from endpoint that retrieves all independent expenditures on a specific date (the date of activity, not the date filed with the FEC).
}
\description{
HTTP Request: GET https://api.propublica.org/campaign-finance/v1/{cycle}/independent_expenditures/{year}/{month}/{day}
}
\examples{
\donttest{
get_independent_expenditure_by_date(2016, year = 2018, month ='01', day = '01')
}
}
