% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_subjects_for_bill.R
\name{get_subjects_for_bill}
\alias{get_subjects_for_bill}
\title{Get Subjects for a Specific Bill}
\usage{
get_subjects_for_bill(congress, bill_id, page = 1, myAPI_Key)
}
\arguments{
\item{congress}{105-116}

\item{bill_id}{a bill slug, for example hr4881 - these can be found in the recent bill response.}

\item{page}{Results come in batches of 20. The page parameter specifies which one to retrieve.}

\item{myAPI_Key}{API key from Propublica To use the congress API, you must sign up for an API key.}
}
\value{
List of returned JSON from endpoint that retrieves the 20 most recent results and supports paginated requests.
}
\description{
HTTP Request: GET https://api.propublica.org/congress/v1/{congress}/bills/{bill-id}/subjects.json. Use this request type to get Library of Congress-assigned subjects about a particular bill.
}
\examples{
\donttest{
get_subjects_for_bill(115, 'hr1628')
}
}
