% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Distributions_depratio.R
\name{pQF_depratio}
\alias{pQF_depratio}
\title{Cumulative Distribution Function of the Dependent QFs Ratio}
\usage{
pQF_depratio(
  q = NULL,
  lambdas = NULL,
  A = NULL,
  B = NULL,
  eps = 1e-06,
  maxit_comp = 1e+05,
  lambdas_tol = NULL
)
}
\arguments{
\item{q}{quantile.}

\item{lambdas}{vector of eigenvalues of the matrix (A-qB).}

\item{A}{matrix of the numerator QF. If not specified but \code{B} is passed, it is assumed to be the identity.}

\item{B}{matrix of the numerator QF. If not specified but \code{A} is passed, it is assumed to be the identity.}

\item{eps}{requested absolute error.}

\item{maxit_comp}{maximum number of iterations.}

\item{lambdas_tol}{maximum value admitted for the weight skewness for both the numerator and the denominator. When it is not NULL (default), elements of lambdas such that the ratio max(lambdas)/lambdas is greater than the specified value are removed.}
}
\value{
The values of the CDF at quantiles \code{q}.
}
\description{
The function computes the CDF of the ratio of two dependent and possibly indefinite quadratic forms.
}
\details{
The distribution function of the following ratio of dependent quadratic forms is computed:
\deqn{P\left(\frac{Y^TAY }{Y^TBY}<q\right),}
where \eqn{Y\sim N(0, I)}.

The transformation to the following indefinite quadratic form is exploited:
\deqn{P\left(Y^T(A-qB)Y <0\right).}

The following inputs can be provided:

\itemize{
\item{vector \code{lambdas} that contains the eigenvalues of the matrix \eqn{(A-qB)}}. Input \code{q} is ignored.
\item{matrix \code{A} and/or matrix \code{B}: in these cases \code{q} is required to be not null and an eventual missing specification of one matrix make it equal to the identity.}
}
}
