% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions_for_RGWAS.R
\name{CalcThreshold}
\alias{CalcThreshold}
\title{Function to calculate threshold for GWAS}
\usage{
CalcThreshold(input, sig.level = 0.05, method = "BH")
}
\arguments{
\item{input}{Data frame of GWAS results where the first column is the marker names,
the second and third column is the chromosome amd map position, and the forth column is -log10(p) for each marker.}

\item{sig.level}{Significance level for the threshold. The default is 0.05. You can also assign vector of sinificance levels.}

\item{method}{Three methods are offered:

"BH": Benjamini-Hochberg method. To control FDR, use this method.

"Bonf": Bonferroni method. To perform simple correction of multiple testing, use this method.

"Sidak": Sidak method.

You can also assign two of them by 'method = c("BH", "Bonf")'}
}
\value{
The value of the threshold. If there is no threshold, it returns NA.
}
\description{
Calculate thresholds for the given GWAS (genome-wide association studies) result by the Benjamini-Hochberg method or Bonferroni method.
}
\references{
Benjamini, Y. and Hochberg, Y. (1995) Controlling the false discovery rate:
 a practical and powerful approach to multiple testing. J R Stat Soc. 57(1): 289-300.

Storey, J.D. and Tibshirani, R. (2003) Statistical significance for genomewide studies. Proc Natl Acad Sci. 100(16): 9440-9445.
}
