% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helper.functions.r
\name{orci}
\alias{orci}
\title{Translate logistic regression coefficients into odds ratios with confidence interval}
\usage{
orci(model, digits = 3)
}
\arguments{
\item{model}{An estimated logistic regression model}

\item{digits}{Number of digits after decimal to display}
}
\value{
Returns odds rations and confidence intervals in columns (a matrix class object)
}
\description{
Generates odds-ratios based on logistic regression model coefficients, reported by logregC with orci=TRUE argument
}
\examples{
   library(RCPA3)
   
   \donttest{
   logit.model <- logregC(states$battleground2020 ~ states$vep16.turnout)
   orci(logit.model)
   }
}
\keyword{internal}
