% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_dt.R
\name{.get_dt}
\alias{.get_dt}
\title{.get_dt}
\usage{
.get_dt(
  a_url = NULL,
  group = NULL,
  vars = NULL,
  NAME_GEOID = TRUE,
  predicates = NULL,
  region = NULL,
  regionin = NULL,
  key = NULL
)
}
\arguments{
\item{a_url}{A string that sets the base url address. A calling function will call
the \code{.get_url} function to define this parameter.}

\item{group}{A string that names an entire group of similar variables to be retrieved.
For example the group value "B01001" would return values of all variables related to
"SEX BY AGE".}

\item{vars}{A string vector of variable names to be acquired.}

\item{NAME_GEOID}{A logical which if \code{TRUE} will add "NAME" and "GEO_ID"
variables to 'vars' string vector. The default is \code{TRUE}.}

\item{predicates}{A vector of strings that adds filtering to the list of variables in 'vars'.}

\item{region}{A string that specifies the geography of the request.}

\item{regionin}{A string that sets a qualifier for 'region'.}

\item{key}{All Census Bureau API requests require a client key from the calling function.}
}
\description{
An internal function for sending an R based http GET request
to the US Census Bureau's Census Data API. The function returns a \code{data.table}
with column values based on dataset, vintage, Census variable predicates, and
geography.

See \href{https://www.census.gov/data/developers/guidance.html}{Census Data API User Guide} for
definitions and examples in running an API query.
}
\keyword{internal}
