% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_multi_vintage_data.R
\name{get_multi_vintage_data}
\alias{get_multi_vintage_data}
\title{get_multi_vintage_data}
\usage{
get_multi_vintage_data(
  dataset = NULL,
  vintage_v = NULL,
  vars = NULL,
  region = NULL,
  regionin = NULL,
  key = Sys.getenv("CENSUS_KEY")
)
}
\arguments{
\item{dataset}{A required string that sets the name of the dataset of interest (e.g. "acs/acs5").}

\item{vintage_v}{A required numeric vector that sets the vintages of interest.}

\item{vars}{A required string vector of variable acronym names to be acquired (e.g. "B15002_015").
See RcensusPkg::get_variable_names() for obtaining acronym names.}

\item{region}{A string that specifies the geography of the request. See \code{Rcensus::get_geography()} for
assistance in obtaining these values.}

\item{regionin}{A string that sets a qualifier for \code{region}.}

\item{key}{A string that sets the access key. All Census Bureau API requests require an access key.
Sign-up for a key is free and can be obtained \href{https://api.census.gov/data/key_signup.html}{here}.
The function will check for a global setting of the key via \code{Sys.getenv("CENSUS_KEY")}.
This is a required parameter.}
}
\value{
A \code{data.table}
}
\description{
Get Census Bureau data for a specific dataset, variables, and region
in the form of a \code{data.table} for multiple vintages. The function requires
a Census Bureau access key.
}
\examples{
\dontrun{
  # Requires Census Bureau API key
  # Obtain the median home value (“B25077_001E”) for Deschutes County, Oregon
  #   back to 2005 through 2019.
  library(jsonlite)
  library(data.table)
  library(httr)
  library(usmap)
  library(RcensusPkg)

  # Get the fips codes for state and county
  deschutes_fips <- usmap::fips("OR","Deschutes")
  state <- substr(deschutes_fips,1,2)
  county <- substr(deschutes_fips,3,5)

  RcensusPkg::get_multi_vintage_data(
    dataset = "acs/acs1",
    vintage_v = 2005:2019,
    vars = c("B25077_001E", "B25077_001M"),
    region = paste0("county:", county),
    regionin = paste0("state:", state)
  )
}
}
