% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/long_to_wide.R
\name{long_to_wide}
\alias{long_to_wide}
\title{long_to_wide}
\usage{
long_to_wide(
  dt = NULL,
  id_v = c("NAME", "GEOID"),
  parameter_col = NULL,
  value_col = NULL
)
}
\arguments{
\item{dt}{The required \code{data.table} with a long column format.}

\item{id_v}{A required vector of column names from 'dt' that act as identifiers and
are not part of the widened column.}

\item{parameter_col}{A column name from 'dt' whose unique values will become
column names for the new expanded \code{data.table}.}

\item{value_col}{A required column name or vector of column names from 'dt' whose values will fall under
the new expanded \code{data.table}.}
}
\value{
A reshaped \code{data.table} in the "wide" format.
}
\description{
Reshape a \code{data.table} from a "long" format to a "wide" format.

Function calls \code{data.table::dcast()} to reshape a long single column and
its values to multiple columns.
}
\examples{
\dontrun{
  # Requires Census Bureau API key
  library(data.table)
  library(httr)
  library(jsonlite)
  library(stringr)
  library(RcensusPkg)

  # Request for data from Census Bureau in "long" form
  B19001_1yr_long_dt <- RcensusPkg::get_vintage_data(
    dataset = "acs/acs1",
    vintage = 2016,
    group = "B19001",
    region = "state",
    wide_to_long = TRUE
  )

  # Resulting data.table is in the "long" form. Convert it back to
  # to the wide form.
  B19001_1yr_wide_dt <- RcensusPkg::long_to_wide(
    dt = B19001_1yr_long_dt,
    parameter_col = "variable",
    value_col = c("estimate", "moe")
  )
}
}
