% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nonlinear_LISOMAP.R
\name{do.lisomap}
\alias{do.lisomap}
\title{Landmark Isometric Feature Mapping}
\usage{
do.lisomap(
  X,
  ndim = 2,
  ltype = c("random", "MaxMin"),
  npoints = max(nrow(X)/5, ndim + 1),
  preprocess = c("center", "scale", "cscale", "decorrelate", "whiten"),
  type = c("proportion", 0.1),
  symmetric = c("union", "intersect", "asymmetric"),
  weight = TRUE
)
}
\arguments{
\item{X}{an \eqn{(n\times p)} matrix or data frame whose rows are observations
and columns represent independent variables.}

\item{ndim}{an integer-valued target dimension.}

\item{ltype}{on how to select landmark points, either \code{"random"} or \code{"MaxMin"}.}

\item{npoints}{the number of landmark points to be drawn.}

\item{preprocess}{an option for preprocessing the data. Default is "center". See also \code{\link{aux.preprocess}} for more details.}

\item{type}{a vector of neighborhood graph construction. Following types are supported;
\code{c("knn",k)}, \code{c("enn",radius)}, and \code{c("proportion",ratio)}.
Default is \code{c("proportion",0.1)}, connecting about 1/10 of nearest data points
among all data points. See also \code{\link{aux.graphnbd}} for more details.}

\item{symmetric}{one of \code{"intersect"}, \code{"union"} or \code{"asymmetric"} is supported. Default is \code{"union"}. See also \code{\link{aux.graphnbd}} for more details.}

\item{weight}{\code{TRUE} to perform Landmark Isomap on weighted graph, or \code{FALSE} otherwise.}
}
\value{
a named list containing
\describe{
\item{Y}{an \eqn{(n\times ndim)} matrix whose rows are embedded observations.}
\item{trfinfo}{a list containing information for out-of-sample prediction.}
}
}
\description{
Landmark Isomap is a variant of Isomap in that
it first finds a low-dimensional embedding using a small portion of given dataset
and graft the others in a manner to preserve as much pairwise distance from
all the other data points to landmark points as possible.
}
\examples{
\donttest{
## use iris data
data(iris)
X   <- as.matrix(iris[,1:4])
lab <- as.factor(iris[,5])

## use different number of data points as landmarks
output1 <- do.lisomap(X, npoints=10, type=c("proportion",0.25))
output2 <- do.lisomap(X, npoints=25, type=c("proportion",0.25))
output3 <- do.lisomap(X, npoints=50, type=c("proportion",0.25))

## visualize three different projections
opar <- par(no.readonly=TRUE)
par(mfrow=c(1,3))
plot(output1$Y, pch=19, col=lab, main="10 landmarks")
plot(output2$Y, pch=19, col=lab, main="25 landmarks")
plot(output3$Y, pch=19, col=lab, main="50 landmarks")
par(opar)
}

}
\references{
\insertRef{silva_global_2003}{Rdimtools}
}
\seealso{
\code{\link{do.isomap}}
}
\author{
Kisung You
}
\concept{nonlinear_methods}
