% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rc_uncertainty.R
\name{rc_unc.class}
\alias{rc_unc.class}
\title{An S4 class to represent the Uncertainty of the Return Curve estimates}
\usage{
rc_unc.class(retcurve, blocksize, nboot, nangles, alpha, unc)
}
\description{
An S4 class to represent the Uncertainty of the Return Curve estimates
}
\section{Slots}{

\describe{
\item{\code{retcurve}}{An S4 object of class \code{rc_est.class}.}

\item{\code{blocksize}}{Size of the blocks for the block bootstrap procedure. If \code{1} (default), then a standard bootstrap approach is applied.}

\item{\code{nboot}}{Number of bootstrap samples to be taken. Default is \code{250} samples.}

\item{\code{nangles}}{\loadmathjax{} Number of angles \mjeqn{m}{m} in the interval \mjeqn{(0, \pi/2)}{} \insertCite{MurphyBarltropetal2023}{ReturnCurves}. Default is \code{150} angles.}

\item{\code{alpha}}{Significance level to compute the \mjeqn{(1-\alpha)}{}\% confidence intervals. Default is \code{0.05}.}

\item{\code{unc}}{A list containing the median and mean estimates of the Return Curve, and the lower and upper bound of the confidence interval.}
}}

\keyword{internal}
