% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mbal_gas_model.R
\name{mbal_perform_gas}
\alias{mbal_perform_gas}
\title{Generic function for performance predictions for a gas reservoir}
\usage{
mbal_perform_gas(mbal_lst, time_lst)
}
\arguments{
\item{mbal_lst}{a list object of class 'mbal_gas'}

\item{time_lst}{a list object of class 'time/date'}
}
\value{
a data frame with estimates for fluids saturation, drive indices, production rates, and gas-oil ratios over the pressure history of the reservoir
}
\description{
Generate a data frame of reservoir performance data according to the class of 'mbal_lst' and 'time_lst' objects
}
\examples{
p_pvt <- c(3700, 3650, 3400, 3100, 2800, 2500, 2200, 1900, 1600, 1300, 1000,
700,  600, 400)
Bo <- c(10.057, 2.417, 2.192, 1.916, 1.736, 1.617, 1.504, 1.416, 1.326, 1.268,
1.205, 1.149, 1.131, 1.093)

Rv <- c(84.11765, 84.11765, 70.5, 56.2, 46.5, 39.5, 33.8, 29.9, 27.3, 25.5, 25.9,
28.3, 29.8, 33.5) / 1e6

Rs <- c(11566, 2378, 2010, 1569, 1272, 1067, 873, 719, 565, 461, 349, 249, 218,
141)

Bg <- c(0.87, 0.88, 0.92, 0.99, 1.08, 1.20, 1.35, 1.56, 1.85, 2.28, 2.95, 4.09,
4.68, 6.53) / 1000

cw <- 3e-6

Bwi <- 10.05

Bw <- Bwi * exp(cw * (p_pvt[1] - p_pvt))

muo <- c(0.0612, 0.062, 0.1338, 0.1826, 0.2354, 0.3001, 0.3764, 0.4781, 0.6041,
0.7746, 1.0295, 1.358, 1.855, 2.500)

mug <- c(0.0612, 0.062, 0.0554, 0.0436, 0.0368, 0.0308, 0.0261, 0.0222, 0.0191,
0.0166, 0.0148, 0.0135, 0.0125, 0.0115)

muw <- rep(0.25, length(p_pvt))

pvt_table <- data.frame(p = p_pvt, Bo = Bo, Rs = Rs, Rv = Rv, Bg = Bg, Bw = Bw,
 muo = muo, mug = mug, muw = muw)

p <- c(3700, 3650, 3400, 3100, 2800, 2500, 2200, 1900, 1600, 1300, 1000, 700,
600)

We <- rep(0, length.out = length(p))

Np <- c(0, 28.6, 93, 231, 270, 379, 481, 517.2, 549, 580, 675, 755, 803) *1e3

Gp <- c(0, 0.34, 1.2, 3.3, 4.3, 6.6, 9.1, 10.5, 12, 12.8, 16.4, 19.1, 20.5) * 1e9

Wp <- rep(0, length.out = length(p))

Wi <- rep(0, length.out = length(p))

wf <- rep(1, length.out = length(p))

mbal_param_gas_lst <- mbal_perform_param_gas(input_unit = "Field",
output_unit = "Field", G = 2.41e10, aquifer_model = NULL,
phi = 0.1, swi = 0.2, Np = Np, Gp = Gp, Wp = Wp, Wi = Wi, We = We, pd = 3650,
p = p, pvt = pvt_table, M = 0, cf = 2e-6, wf = wf, sgrw = 0.15)

time_lst <- mbal_time(c(1:length(p)), "year")

mbal_results <- mbal_perform_gas(mbal_param_gas_lst, time_lst)

dplyr::glimpse(mbal_results)
}
\references{
\insertRef{Walsh2003}{Rmbal}

\insertRef{Walsh1994a}{Rmbal}

\insertRef{Walsh1994}{Rmbal}

\insertRef{Walsh1995}{Rmbal}

\insertRef{Fetkovich1998}{Rmbal}
}
