% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eva_functions.R
\name{tsEvaComputeReturnLevelsGEVFromAnalysisObj}
\alias{tsEvaComputeReturnLevelsGEVFromAnalysisObj}
\title{tsEvaComputeReturnLevelsGEVFromAnalysisObj}
\usage{
tsEvaComputeReturnLevelsGEVFromAnalysisObj(
  nonStationaryEvaParams,
  returnPeriodsInYears,
  timeIndex = -1
)
}
\arguments{
\item{nonStationaryEvaParams}{The parameters obtained from a non-stationary extreme value analysis.}

\item{returnPeriodsInYears}{The return periods expressed in years.}

\item{timeIndex}{Temporal index corresponding to the time step on which compute the GEV RLs.}
}
\value{
A list containing the following components:
\describe{
\item{\code{returnLevels}}{A matrix of return levels corresponding to the specified return periods.}
\item{\code{returnLevelsErr}}{A matrix of standard errors for the return levels.}
\item{\code{returnLevelsErrFit}}{A matrix of standard errors for the return levels obtained from fitting the non-stationary model.}
\item{\code{returnLevelsErrTransf}}{A matrix of standard errors for the return levels obtained from the transformed data.}
}
}
\description{
\code{tsEvaComputeReturnLevelsGEVFromAnalysisObj}is a function that calculates the return levels for a Generalized Extreme Value (GEV) distribution using the parameters obtained from a non-stationary extreme value analysis. It supports non-stationary analysis by considering different parameters for each time index.
}
\examples{
# Example usage with some sample data
nonStationaryEvaParams <- list(list(
parameters = list(
  epsilon = 0.1,
  sigma = c(2.1, 2.2, 2.3),
  mu = c(1.1, 1.2, 1.3),
  timeHorizonStart=as.POSIXct("1951-01-01"),
  timeHorizonEnd=as.POSIXct("2020-12-31"),
  nPeaks=90

),
paramErr = list(
  epsilonErr = 0.01,
  sigmaErr = c(0.11, 0.12, 0.13),
  muErr = c(0.011, 0.012, 0.013)
),NA
)
)
returnPeriodsInYears <- c(1, 5, 10, 20, 50)
timeIndex=1
results <- tsEvaComputeReturnLevelsGEVFromAnalysisObj(nonStationaryEvaParams, returnPeriodsInYears)
head(results$returnLevels)
}
\seealso{
\code{\link{tsEvaComputeReturnLevelsGEV}}
}
