% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check_logical.R
\name{check_parameter_rules}
\alias{check_parameter_rules}
\title{Check parameter values against logical rules}
\usage{
check_parameter_rules(
  data,
  param_conditions = get(".param_conditions", envir = asNamespace("SHARK4R")),
  rowwise_conditions = get(".rowwise_conditions", envir = asNamespace("SHARK4R")),
  return_df = FALSE,
  return_logical = FALSE,
  verbose = TRUE
)
}
\arguments{
\item{data}{A data frame containing at least the columns \code{parameter} and \code{value}.}

\item{param_conditions}{A named list of parameter-specific rules.
Each element should be a list with:
\describe{
\item{condition}{Function taking a numeric vector and returning a logical vector (TRUE = violation).}
\item{range_msg}{Character string describing the expected range.}
}
Defaults to \code{SHARK4R:::.param_conditions} defined in the package namespace.}

\item{rowwise_conditions}{A named list of row-wise rules applied across multiple parameters.
Each element should be a function taking the full data frame and returning a logical vector.
Defaults to \code{SHARK4R:::.rowwise_conditions} defined in the package namespace.}

\item{return_df}{Logical. If TRUE, problematic rows are returned as plain \code{data.frame}s.}

\item{return_logical}{Logical. If TRUE, problematic rows are returned as logical vectors.
Overrides \code{return_df}.}

\item{verbose}{Logical. If TRUE, messages will be displayed during execution. Defaults to TRUE.}
}
\value{
A named list of results for each parameter:
\describe{
\item{Logical vector}{If \code{return_logical = TRUE}.}
\item{Data frame}{If \code{return_df = TRUE} and violations exist.}
\item{DT datatable}{If violations exist and \code{return_df = FALSE}.}
\item{NULL}{If no violations exist for the parameter.}
}
Invisible return.
}
\description{
Applies parameter-specific and row-wise logical rules to benthos/epibenthos data,
flagging measurements that violate defined conditions. This function replaces
multiple deprecated \verb{check_*_logical()} functions with a general, flexible implementation.
}
\details{
This function evaluates each parameter in \code{param_conditions} and \code{rowwise_conditions}.
Only parameters present in the dataset are checked. Messages are printed
indicating whether values are within expected ranges or which rows violate rules.
}
\examples{
df <- data.frame(
  station_name = c("A1", "A2", "A3", "A4"),
  sample_date = as.Date("2023-05-01") + 0:3,
  sample_id = 101:104,
  parameter = c("Wet weight", "Wet weight", "Abundance", "BQIm"),
  value = c(0, 5, 0, 3)
)

# Check against default package rules
check_parameter_rules(df)

# Return problematic rows as data.frame
check_parameter_rules(df, return_df = TRUE)

# Return logical vectors for each parameter
rule_check <- check_parameter_rules(df, return_logical = TRUE)
print(rule_check)

}
