% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mts.plot.R
\name{mts.plot}
\alias{mts.plot}
\title{Plot Multiple Time Series in One Frame}
\usage{
mts.plot(x, title = "mts plot", scaling = TRUE, xtime = NULL)
}
\arguments{
\item{x}{T by k data matrix: T data points in rows with each row being data at a given time point,
and k time series in columns.}

\item{title}{Character with the title of the plot. Default title is "mts plot".}

\item{scaling}{If scaling = TRUE (default), then each series is standardized based on its own range.
If scaling = FALSE, then the original series is used.}

\item{xtime}{A vector with the values for the x labels. Default values are 1, 2, 3, ...}
}
\value{
standardized - Matrix containing the standardized time series.
}
\description{
Plot multiple time series in one frame and return standardized time series.
}
\examples{
data(TaiwanAirBox032017)
output <- mts.plot(TaiwanAirBox032017[,1:5])
}
