% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R,
%   R/S3_CoefficientOfDetermination.R
\name{rsq.numeric}
\alias{rsq.numeric}
\alias{weighted.rsq.numeric}
\alias{rsq}
\alias{weighted.rsq}
\title{\eqn{R^2}}
\usage{
\method{rsq}{numeric}(actual, predicted, k = 0, ...)

\method{weighted.rsq}{numeric}(actual, predicted, w, k = 0, ...)

## Generic S3 method
rsq(
 ...,
 k = 0
)

## Generic S3 method
weighted.rsq(
 ...,
 w,
 k = 0
)
}
\arguments{
\item{actual}{A <\link{numeric}>-vector of \link{length} \eqn{n}. The observed (continuous) response variable.}

\item{predicted}{A <\link{numeric}>-vector of \link{length} \eqn{n}. The estimated (continuous) response variable.}

\item{k}{A <\link{numeric}>-vector of \link{length} 1 (default: 0). For adjusted \eqn{R^2} set \eqn{k = \kappa - 1}, where \eqn{\kappa} is the number of parameters.}

\item{...}{Arguments passed into other methods.}

\item{w}{A <\link{numeric}>-vector of \link{length} \eqn{n}. The weight assigned to each observation in the data.}
}
\value{
A <\link{numeric}> vector of \link{length} 1.
}
\description{
A generic function for the \href{https://en.wikipedia.org/wiki/Coefficient_of_determination}{\eqn{R^2}}. The unadjusted \href{https://en.wikipedia.org/wiki/Coefficient_of_determination}{\eqn{R^2}} is returned by default.
Use \code{\link[=weighted.rsq]{weighted.rsq()}} for the weighted \href{https://en.wikipedia.org/wiki/Coefficient_of_determination}{\eqn{R^2}}.
}
\section{Definition}{

Let \eqn{R^2 \in [-\infty, 1]} be the explained variation. The \eqn{R^2} is calculated as,

\deqn{
  R^2 = 1 - \frac{\sum{(y_i - \hat{y}_i)^2}}{\sum{(y_i-\bar{y})^2}} \frac{n-1}{n - (k + 1)}
}

Where:
\itemize{
\item \eqn{n} is the number of observations
\item \eqn{k} is the number of features
\item \eqn{y} is the actual values
\item \eqn{\hat{y}_i} is the predicted values
\item \eqn{\sum{(y_i - \hat{y}_i)^2}} is the sum of squared errors and,
\item \eqn{\sum{(y_i-\bar{y})^2}} is total sum of squared errors
}
}

\examples{
# 1) fit a linear
# regression
model <- lm(
  mpg ~ .,
  data = mtcars
)

# 1.1) define actual
# and predicted values
# to measure in-sample performance
actual    <- mtcars$mpg
predicted <- fitted(model)

# 2) calculate performance
# using R squared adjusted and
# unadjused for features
cat(
  "Rsq", rsq(
    actual    = actual,
    predicted = fitted(model)
  ),
  "Rsq (Adjusted)", rsq(
    actual    = actual,
    predicted = fitted(model),
    k = ncol(model.matrix(model)) - 1
  ),
  sep = "\n"
)
}
\seealso{
Other Regression: 
\code{\link{ccc.numeric}()},
\code{\link{huberloss.numeric}()},
\code{\link{mae.numeric}()},
\code{\link{mape.numeric}()},
\code{\link{mpe.numeric}()},
\code{\link{mse.numeric}()},
\code{\link{pinball.numeric}()},
\code{\link{rae.numeric}()},
\code{\link{rmse.numeric}()},
\code{\link{rmsle.numeric}()},
\code{\link{rrmse.numeric}()},
\code{\link{rrse.numeric}()},
\code{\link{smape.numeric}()}

Other Supervised Learning: 
\code{\link{ROC.factor}()},
\code{\link{accuracy.factor}()},
\code{\link{baccuracy.factor}()},
\code{\link{ccc.numeric}()},
\code{\link{ckappa.factor}()},
\code{\link{cmatrix.factor}()},
\code{\link{dor.factor}()},
\code{\link{entropy.matrix}()},
\code{\link{fbeta.factor}()},
\code{\link{fdr.factor}()},
\code{\link{fer.factor}()},
\code{\link{fpr.factor}()},
\code{\link{huberloss.numeric}()},
\code{\link{jaccard.factor}()},
\code{\link{logloss.factor}()},
\code{\link{mae.numeric}()},
\code{\link{mape.numeric}()},
\code{\link{mcc.factor}()},
\code{\link{mpe.numeric}()},
\code{\link{mse.numeric}()},
\code{\link{nlr.factor}()},
\code{\link{npv.factor}()},
\code{\link{pinball.numeric}()},
\code{\link{plr.factor}()},
\code{\link{pr.auc.matrix}()},
\code{\link{prROC.factor}()},
\code{\link{precision.factor}()},
\code{\link{rae.numeric}()},
\code{\link{recall.factor}()},
\code{\link{rmse.numeric}()},
\code{\link{rmsle.numeric}()},
\code{\link{roc.auc.matrix}()},
\code{\link{rrmse.numeric}()},
\code{\link{rrse.numeric}()},
\code{\link{smape.numeric}()},
\code{\link{specificity.factor}()},
\code{\link{zerooneloss.factor}()}
}
\concept{Regression}
\concept{Supervised Learning}
