% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/msi.dataset_methods.R
\name{binKmeans,msi.dataset-method}
\alias{binKmeans,msi.dataset-method}
\alias{binKmeans}
\title{Return a binary mask generated applying k-means clustering
on first 10 principal components of peaks intensities.}
\usage{
\S4method{binKmeans}{msi.dataset}(object, ref = "detected", invert = FALSE, npcs = 10)
}
\arguments{
\item{object}{\link{msi.dataset-class} object}

\item{ref}{string (default = "detected). Sample reference image used to align
the clusters.}

\item{invert}{boolean (default = FALSE). If FALSE, the clusters are inversely aligned to the
sample reference image.}

\item{npcs}{int (default = 10). Number of principal components to calculate.}
}
\value{
\link{ms.image-class} object representing the binary mask image.
}
\description{
Return a binary mask generated applying k-means clustering
on first 10 principal components of peaks intensities.
}
\examples{
## Load package
library("SPUTNIK")

## Create the msi.dataset-class object
sz <- c(5, 4)
x <- matrix(rnorm(sz[1] * sz[2] * 20), sz[1] * sz[2], 20)
x[x < 0] <- 0
mz <- sort(sample(100, ncol(x)))
msiX <- msiDataset(x, mz, sz[1], sz[2])

## Generate binary mask by applying k-means on the entire dataset
roiImg <- refImageBinaryKmeans(msiX, npcs = 3)

## Plot the mask
# plot(roiImg)
}
