#' Shopping bags
#'
#' Age of people, and whether they bring their own shopping bags.
#' 
#' @docType data
#' 
#' @keywords datasets
#'
#' @format A data frame with 6 rows and 3 columns:
#' \describe{
#'   \item{AgeGroup}{The age group: \code{1} means '30 and under'; \code{2} means '31 to 40'; \code{3} means 'Over 40'}
#'   \item{BringBags}{Whether people bring their own shopping bags or not; \code{y} means they do; \code{n} means they do not}
#'   \item{Counts}{The number of people in each designated category}
#' }
#' @source From Tables 1 and 5 of:
#' Choon, S. W., Tan, S. H., & Chong, L. L. (2017). 
#' The perception of households about solid waste management 
#'  issues in Malaysia. 
#' \emph{Environment, Development and Sustainability}, \bold{19}, 1685--1700.
#' 
#' @usage 
#' data(ShoppingBags)
#' 
#' @examples
#' barplot( xtabs(Counts ~ BringBags + AgeGroup, data = ShoppingBags), names.arg = c("30 and under", "31 to 40", "Over 40"), ylab = "Number of shoppers")
#' 

"ShoppingBags"
