% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/COREG.R
\name{COREG}
\alias{COREG}
\title{General Interface for COREG model}
\usage{
COREG(max.iter = 50, k1 = 3, k2 = 5, p1 = 3, p2 = 5, u = 100)
}
\arguments{
\item{max.iter}{maximum number of iterations to execute the self-labeling process.
Default is 50.}

\item{k1}{parameter in first KNN}

\item{k2}{parameter in second KNN}

\item{p1}{distance order 1. Default is 3}

\item{p2}{distance order 1. Default is 5}

\item{u}{Number of unlabeled instances in the pool. Default is 100.}
}
\description{
COREG is a semi-supervised learning for regression with a co-training style.
This technique uses two kNN regressors with different distance metrics.
For each iteration, each regressor labels the unlabeled
example which can be most confidently labeled for the other
learner, where the labeling confidence is estimated through
considering the consistency of the regressor with the labeled
example set. The final prediction is made by averaging the
predictions of both the refined kNN regressors
}
\details{
labeling data is very expensive computationally. Its so slow. For executing this model, we need RANN installed.
}
\examples{
library(SSLR)

m <- COREG(max.iter = 1)

}
\references{
Zhi-Hua Zhou and Ming Li.\cr
\emph{Semi-Supervised Regression with Co-Training.}\cr
National Laboratory for Novel Software Technology
Nanjing University, Nanjing 210093, China
}
