% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plot.Torgegram}
\alias{plot.Torgegram}
\title{Plot Torgegram}
\usage{
\method{plot}{Torgegram}(x, type, separate = FALSE, ...)
}
\arguments{
\item{x}{A Torgegram object from \code{\link[=Torgegram]{Torgegram()}}.}

\item{type}{The type of semivariogram. Can take character values that are a subset
of objects in \code{x}. The default is \code{names(x)}.}

\item{separate}{When \code{type} is length greater than one, whether each
\code{type} be placed in a separate plot. The default is \code{FALSE}.}

\item{...}{Other arguments passed to other methods.}
}
\value{
No return value. Function called for plotting side effects.
}
\description{
Plot Torgegram
}
\examples{
# Copy the mf04p .ssn data to a local directory and read it into R
# When modeling with your .ssn object, you will load it using the relevant
# path to the .ssn data on your machine
copy_lsn_to_temp()
temp_path <- paste0(tempdir(), "/MiddleFork04.ssn")
mf04p <- ssn_import(temp_path, overwrite = TRUE)

tg <- Torgegram(Summer_mn ~ 1, mf04p)
plot(tg)
}
\seealso{
\link{plot.SSN2}
}
