% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ssn_get_data.R
\name{ssn_get_data}
\alias{ssn_get_data}
\title{Get a data.frame from an SSN, ssn_lm, or ssn_glm object}
\usage{
ssn_get_data(x, name = "obs")
}
\arguments{
\item{x}{An object of class \code{SSN}, \code{ssn_lm}, or \code{ssn_glm}.}

\item{name}{the internal name of the dataset in the object
\code{x}. For observed values, this will always be "obs", the
default.}
}
\value{
An sf data.frame
}
\description{
The \command{ssn_get_data} function extracts an
sf data.frame for the observation or prediction data from
an \code{SSN}, \code{ssn_lm}, or \code{ssn_glm} object.
}
\details{
The internal \code{name} for observed data in objects of
class \code{SSN} is "obs" and it is the
default. If another \code{name} is specified, it must represent a
prediction data set in the \code{SSN},
\code{ssn_lm}, or \code{ssn_glm} object. For \code{SSN} objects,
these names are obtained using the call \code{names(x$preds)}. For
all other object classes, the names are obtained using the call
\code{names(x$ssn.object$preds)}.
}
\examples{
## Extract observed data from an SSN object
# Copy the mf04p .ssn data to a local directory and read it into R
# When modeling with your .ssn object, you will load it using the relevant
# path to the .ssn data on your machine
copy_lsn_to_temp()
temp_path <- paste0(tempdir(), "/MiddleFork04.ssn")
mf04p <- ssn_import(temp_path, predpts = "pred1km", overwrite = TRUE)

obs.df <- ssn_get_data(mf04p)
dim(obs.df)

## Extract prediction data from an SSN object
names(mf04p$preds)
pred1km.df <- ssn_get_data(mf04p, name = "pred1km")
names(pred1km.df)

## extract observed data from an ssn_lm object
ssn_mod <- ssn_lm(
  formula = Summer_mn ~ ELEV_DEM,
  ssn.object = mf04p,
  tailup_type = "exponential",
  additive = "afvArea"
)
obs.mod.df <- ssn_get_data(ssn_mod)
summary(obs.mod.df)
}
\seealso{
\code{\link[=ssn_put_data]{ssn_put_data()}}
}
