% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RunAnalyses.R
\name{runSccsAnalyses}
\alias{runSccsAnalyses}
\title{Run a list of analyses}
\usage{
runSccsAnalyses(
  connectionDetails,
  cdmDatabaseSchema,
  tempEmulationSchema = getOption("sqlRenderTempEmulationSchema"),
  exposureDatabaseSchema = cdmDatabaseSchema,
  exposureTable = "drug_era",
  outcomeDatabaseSchema = cdmDatabaseSchema,
  outcomeTable = "cohort",
  customCovariateDatabaseSchema = cdmDatabaseSchema,
  customCovariateTable = "cohort",
  nestingCohortDatabaseSchema = cdmDatabaseSchema,
  nestingCohortTable = "cohort",
  outputFolder,
  sccsMultiThreadingSettings = createSccsMultiThreadingSettings(),
  sccsAnalysesSpecifications
)
}
\arguments{
\item{connectionDetails}{An R object of type \code{ConnectionDetails} created using
the function \code{\link[DatabaseConnector:createConnectionDetails]{DatabaseConnector::createConnectionDetails()}}.}

\item{cdmDatabaseSchema}{The name of the database schema that contains the OMOP CDM
instance.  Requires read permissions to this database. On
SQL Server, this should specify both the database and the
schema, so for example 'cdm_instance.dbo'.}

\item{tempEmulationSchema}{Some database platforms like Oracle and Impala do not truly support
temp tables. To emulate temp tables, provide a schema with write
privileges where temp tables can be created.}

\item{exposureDatabaseSchema}{The name of the database schema that is the location where
the exposure data used to define the exposure cohorts is
available. If \code{exposureTable = "DRUG_ERA"},
\code{exposureDatabaseSchema} is not used but assumed to be
\code{cdmDatabaseSchema}.  Requires read permissions to this database.}

\item{exposureTable}{The table name that contains the exposure cohorts.  If
\verb{exposureTable <> "DRUG_ERA"}, then expectation is \code{exposureTable}
has format of COHORT table: cohort_concept_id, SUBJECT_ID,
COHORT_START_DATE, COHORT_END_DATE.}

\item{outcomeDatabaseSchema}{The name of the database schema that is the location where
the data used to define the outcome cohorts is available. Requires
read permissions to this database.}

\item{outcomeTable}{The table name that contains the outcome cohorts.}

\item{customCovariateDatabaseSchema}{The name of the database schema that is the location where
the custom covariate data is available.}

\item{customCovariateTable}{Name of the table holding the custom covariates. This table
should have the same structure as the cohort table.}

\item{nestingCohortDatabaseSchema}{The name of the database schema that is the location
where the nesting cohort is defined.}

\item{nestingCohortTable}{Name of the table holding the nesting cohort. This table
should have the same structure as the cohort table.}

\item{outputFolder}{Name of the folder where all the outputs will written to.}

\item{sccsMultiThreadingSettings}{An object of type \code{SccsMultiThreadingSettings} as created using
the \code{\link[=createSccsMultiThreadingSettings]{createSccsMultiThreadingSettings()}} or
\code{\link[=createDefaultSccsMultiThreadingSettings]{createDefaultSccsMultiThreadingSettings()}} functions.}

\item{sccsAnalysesSpecifications}{An object of type \code{SccsAnalysesSpecifications} as created using
the \code{\link[=createSccsAnalysesSpecifications]{createSccsAnalysesSpecifications()}} function}
}
\value{
A tibble describing for each exposure-outcome-analysisId combination where the intermediary and
outcome model files can be found, relative to the \code{outputFolder}.
}
\description{
Run a list of analyses
}
\details{
Run a list of analyses for the exposures-outcomes of interest. This function will run all
specified analyses against all hypotheses of interest, meaning that the total number of outcome
models is \code{length(sccsAnalysisList) * length(exposuresOutcomeList)} When you provide several analyses
it will determine whether any of the analyses have anything in common, and will take advantage of
this fact.
\subsection{Analyses to Exclude}{

Normally, \code{runSccsAnalyses} will run all combinations of exposures-outcome-analyses settings.
However, sometimes we may not need all those combinations. Using the \code{analysesToExclude} argument,
we can remove certain items from the full matrix. This argument should be a data frame with at least
one of the following columns:
\itemize{
\item exposureId
\item outcomeId
\item nestingCohortId
\item analysisId
}

This data frame will be joined to the outcome model reference table before executing, and matching rows
will be removed. For example, if one specifies only one exposure ID and analysis ID, then any analyses with
that exposure and that analysis ID will be skipped.
}
}
