% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pmcmc.R
\docType{class}
\name{SimInf_pmcmc-class}
\alias{SimInf_pmcmc-class}
\title{Class \code{"SimInf_pmcmc"}}
\description{
Class \code{"SimInf_pmcmc"}
}
\section{Slots}{

\describe{
\item{\code{model}}{The \code{SimInf_model} object to estimate parameters
in.}

\item{\code{priors}}{A \code{data.frame} containing the four columns
\code{parameter}, \code{distribution}, \code{p1} and
\code{p2}. The column \code{parameter} gives the name of the
parameter referred to in the model. The column
\code{distribution} contains the name of the prior
distribution. Valid distributions are 'gamma', 'normal' or
'uniform'. The column \code{p1} is a numeric vector with the
first hyperparameter for each prior: 'gamma') shape,
'lognormal') logmean, 'normal') mean, and 'uniform') lower
bound. The column \code{p2} is a numeric vector with the
second hyperparameter for each prior: 'gamma') rate,
'lognormal') standard deviation on the log scale, 'normal')
standard deviation, and 'uniform') upper bound.}

\item{\code{target}}{Character vector (\code{gdata} or \code{ldata}) that
determines if the \code{pmcmc} method estimates parameters in
\code{model@gdata} or in \code{model@ldata}.}

\item{\code{pars}}{Index to the parameters in \code{target}.}

\item{\code{n_particles}}{An integer with the number of particles (> 1) to
use in the bootstrap particle filter.}

\item{\code{data}}{A \code{data.frame} holding the time series data for
the observation process.}

\item{\code{chain}}{A matrix where each row contains \code{logPost},
\code{logLik}, \code{logPrior}, \code{accept}, and the
\code{parameters} for each iteration.}

\item{\code{covmat}}{A named numeric \code{(npars x npars)} matrix with
covariances to use as initial proposal matrix.}

\item{\code{adaptmix}}{Mixing proportion for adaptive proposal.}

\item{\code{adaptive}}{Controls when to start adaptive update.}
}}

\seealso{
\code{\link{pmcmc}} and \code{\link{continue_pmcmc}}.
}
