% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print.tdi.R
\name{print.tdi}
\alias{print.tdi}
\title{Printing tdi objects}
\usage{
\method{print}{tdi}(x, ...)
}
\arguments{
\item{x}{input object of class \code{tdi} resulting from a call of the function \code{\link[TDIagree]{TDI}}.}

\item{...}{currently not in use}
}
\value{
A nice \strong{gt} table containing the values computed with the function \code{\link[TDIagree]{TDI}}.
         The number of decimals for the estimates and the proportions correspond to the arguments \code{dec.est} and \code{dec.p} of the function \code{\link[TDIagree]{TDI}}, respectively.
}
\description{
A nice gt table containing the values computed with the function TDI.
}
\examples{
# normal data

set.seed(2025)

n <- 100

mu.ind <- rnorm(n, 0, 7)

epsA1 <- rnorm(n, 0, 3)
epsA2 <- rnorm(n, 0, 3)
epsB1 <- rnorm(n, 0, 3)
epsB2 <- rnorm(n, 0, 3)

y_A1 <- 50 + mu.ind + epsA1 # rater A, replicate 1
y_A2 <- 50 + mu.ind + epsA2 # rater A, replicate 2
y_B1 <- 40 + mu.ind + epsB1 # rater B, replicate 1
y_B2 <- 40 + mu.ind + epsB2 # rater B, replicate 2

ex_data <- data.frame(y = c(y_A1, y_A2, y_B1, y_B2),
                      rater = factor(rep(c("A", "B"), each = 2*n)),
                      replicate = factor(rep(rep(1:2, each = n), 2)),
                      subj = factor(rep(1:n, 4)))

tdi <- TDI(ex_data, y, subj, rater, replicate, p = c(0.8, 0.9),
           method = c("Choudhary P", "Escaramis et al.",
                      "Choudhary NP", "Perez-Jaume and Carrasco"),
           boot.type = "cluster", R = 1000)
tdi


# non-normal data

tdi.aml <- TDI(AMLad, mrd, id, met, rep, p = c(0.85, 0.95), boot.type = "cluster",
               dec.est = 4, R = 1000)
tdi.aml


}
