% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tprBark.r
\name{tprBark}
\alias{tprBark}
\alias{tprBark,tprTrees-method}
\title{Functions to calculate double bark thickness for given diameter at
height \code{Hx}}
\usage{
tprBark(obj, Hx, cp = TRUE, mono = TRUE, Rfn = NULL)

\S4method{tprBark}{tprTrees}(obj, Hx, cp = TRUE, mono = TRUE, Rfn = NULL)
}
\arguments{
\item{obj}{object of class 'tprTrees'}

\item{Hx}{height for which double bark thickness is required}

\item{cp}{cartesian product, i.e. apply all \code{Hx} to all trees, defaults
to TRUE}

\item{mono}{logical, defaults to true. If calibrated taper curve is
non-monotonic at stem base, an support diameter is added.}

\item{Rfn}{Rfn setting for residuals error matrix, defaults to
\code{list(fn="sig2")}, see \code{\link[TapeR]{resVar}}.}
}
\value{
double bark thickness [cm]
}
\description{
Funktion evaluates the double bark thickness models developed
by Altherr et al (1974-79).
}
\section{Methods (by class)}{
\itemize{
\item \code{tprBark(tprTrees)}: method for class 'tprTrees'

}}
\examples{
## calculating bark thickness depends on diameter estimation and hence on the
## assumed residual variance at calibration.
## can be Rfn=list(fn="sig2") (default), i.e. EBLUP estimation from taper curve
## or e.g. Rfn=list(fn="zero"), i.e. force taper curve through the given measurements
options("TapeS_Rfn") # "sig2", default in TapeS
tmp <- tprTrees()
Dm(tmp); Hm(tmp) # Dbh = D(Hx=1.3) = 30cm (measured)
Dbh(tmp) # estimated via EBLUP from taper curve
tprBark(tmp, Hx = c(1.3, 5)) # bark thickness corresponds to Dbh(tmp)
(d <- tprDiameter(tmp, Hx = c(1.3, 5), bark=TRUE)) ## predicted
bark(1, d[1], 1.3/30) # the same!
bark(1, d[2], 5/30) # the same!

## if using option TapeS_Rfn = list(fn="zero"), force taper curve through measurements
setTapeSoptions(Rfn = list(fn="zero"))
options()$TapeS_Rfn
tprBark(tmp, Hx = c(1.3, 5))
bark(1, 30, 1.3/30) # the same but different to above
bark(1, d[1], 1.3/30) # cf. above
bark(1, 28, 5/30) # the same but different to above
bark(1, d[2], 1.3/30) # cf. above
}
\references{
Altherr, E., P. Unfried, J. Hradetzky and V. Hradetzky (1974).
Statistische Rindenbeziehungen als Hilfsmittel zur Ausformung und Aufmessung
unentrindeten Stammholzes. Kiefer, Buche, Hainbuche, Esche und Roterle.
Freiburg i. Br., Forstl. Versuchs- u. Forschungsanst. Baden-Württenberg.

Altherr, E., P. Unfried, J. Hradetzky and V. Hradetzky (1975). Statistische
Rindenbeziehungen als Hilfsmittel zur Ausformung und Aufmessung unentrindeten
 Stammholzes. Europäische Lärche, Japanische Lärche, Schwarzkiefer,
 Stieleiche, Traubeneiche, Roteiche, Bergahorn und Linde. Freiburg i. Br.,
 Forstl. Versuchs- u. Forschungsanst. Baden-Württenberg.

Altherr, E., P. Unfried, J. Hradetzky and V. Hradetzky (1976). Statistische
Rindenbeziehungen als Hilfsmittel zur Ausformung und Aufmessung unentrindeten
 Stammholzes. Weymouthskiefer, Robinie, Bergulme, Birke, Marilandica-Pappel
 und Robusta-Pappel. Freiburg i. Br., Forstl. Versuchs- u. Forschungsanst.
 Baden-Württenberg.

Altherr, E., P. Unfried, J. Hradetzky and V. Hradetzky (1978). Statistische
Rindenbeziehungen als Hilfsmittel zur Ausformung und Aufmessung unentrindeten
 Stammholzes. Fichte, Tanne, Douglasie und Sitka-Fichte. Freiburg i. Br.,
 Forstl. Versuchs- u. Forschungsanst. Baden-Württenberg.

Altherr, E., P. Unfried, J. Hradetzky and V. Hradetzky (1979). Statistische
Rindenbeziehungen als Hilfsmittel zur Ausformung und Aufmessung unentrindeten
 Stammholzes. Neupotz-Pappel, Regenerata-Pappel, Kirsche, Spitzahorn,
 Feldahorn, Aspe, Weide, Flatterulme, Tulpenbaum u. Elsbeere.
 Freiburg i. Br., Forstl. Versuchs- u. Forschungsanst. Baden-Württenberg.
}
