% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/signT.R
\name{fit_continuous_cp}
\alias{fit_continuous_cp}
\title{Signal tensor estimation from a noisy and incomplete data tensor based on CP low rank tensor method.}
\usage{
fit_continuous_cp(data,r)
}
\arguments{
\item{data}{A given (possibly noisy and incomplete) data tensor.}

\item{r}{A rank to be fitted (CP rank).}
}
\value{
The returned object is a list of components.

\code{est} - An estimated signal tensor based on CP low rank tensor method.

\code{U} - A list of factor matrices.

\code{lambda} - A vector of tensor singular values.
}
\description{
Estimate a signal tensor from a noisy and incomplete data tensor using CP low rank tensor method.
}
\examples{
library(tensorregress)
indices = c(2,3,4)
noise = rand_tensor(indices)@data
Theta = array(runif(prod(indices),min=-3,max = 3),indices)

# The signal plus noise model
Y = Theta + noise

# Estimate Theta from CP low rank tensor method
hatTheta = fit_continuous_cp(Y,3)
print(hatTheta$est)

}
