% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/08-helpers.R
\name{extract_numeric_values}
\alias{extract_numeric_values}
\title{Extract length values from column names}
\usage{
extract_numeric_values(
  column_names,
  use_fallback = TRUE,
  fallback_type = "sequential",
  verbose = FALSE
)
}
\arguments{
\item{column_names}{Character vector of column names.}

\item{use_fallback}{Logical. If TRUE, uses fallback strategy when
numeric values cannot be extracted.}

\item{fallback_type}{Character. Type of fallback to use when use_fallback = TRUE.
Options: "sequential", "ones", "zeros".}

\item{verbose}{Logical. Print information about extraction strategy used.}
}
\value{
Numeric vector of length values extracted from column names.
}
\description{
Helper function to extract numerical length values from column names.
Handles different naming patterns like "length_8.5", "weighted_9", "8", etc.
Uses multiple extraction strategies to ensure robust parsing of column names.
}
\details{
The function uses the following extraction strategies in order:
\enumerate{
\item Specific prefixes: "length_", "weighted_", "pond_" followed by numbers
\item Purely numeric column names
\item General pattern: extracts first number found in each name
\item Fallback: uses specified fallback strategy if previous methods fail
}
}
\examples{
extract_numeric_values(c("length_8.5", "weighted_10", "pond_12"))
extract_numeric_values(c("8", "10.5", "12"))
extract_numeric_values(c("size_8", "data_10.5", "value_12"))
extract_numeric_values(c("length_8", "no_numbers"), use_fallback = FALSE)
extract_numeric_values(c("bad_name1", "bad_name2"), fallback_type = "ones")

}
