% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/04-fishery-statistics.R
\name{summarize_juveniles_by_group}
\alias{summarize_juveniles_by_group}
\title{Summarize juveniles by group}
\usage{
summarize_juveniles_by_group(
  data,
  group_cols,
  length_cols = NULL,
  juvenile_limit = 12,
  a = 0.0012,
  b = 3.1242,
  remove_empty = TRUE,
  verbose = FALSE
)
}
\arguments{
\item{data}{Data frame with length frequency data.}

\item{group_cols}{Vector of column names for grouping.}

\item{length_cols}{Vector of length column names or indices. If NULL, auto-detection is attempted.}

\item{juvenile_limit}{Length threshold for juveniles.}

\item{a}{Coefficient of length-weight relationship.}

\item{b}{Exponent of length-weight relationship.}

\item{remove_empty}{Logical. Remove groups with no data.}

\item{verbose}{Logical. Print information about detected columns.}
}
\value{
Data frame with juvenile statistics by group.
}
\description{
Calculates juvenile percentages by specified groups, both in number and weight.
Uses modern dplyr approach for efficient processing. Can auto-detect length columns
if not specified.
}
\examples{
\dontrun{
juvenile_summary <- summarize_juveniles_by_group(
  data = fishery_data,
  group_cols = "date",
  juvenile_limit = 12
)
}

}
