% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/All.R
\name{NGRDist}
\alias{NGRDist}
\title{British national grid reference (NGR) distances}
\usage{
NGRDist(i, j)
}
\arguments{
\item{i}{a numeric vector of length two. The first being the easting and the second being the northing of the first site}

\item{j}{a numeric vector of length two. The first being the easting and the second being the northing of the second site}
}
\value{
A distance in kilometres (if British national grid easting and northing are applied)
}
\description{
Calculates the Euclidean distance between two British national grid reference points using the Pythagorean/Euclidean method.
}
\details{
Note, that the result is converted to km from m.
}
\examples{
# Calculate the distance between the catchment centroid for the
# Kingston upon Thames river gauge and the catchment centroid for the
# gauge at Ardlethen on the River Ythan.
# First retrieve the catchment descriptors (CDs) to obtain eastings and northings
GetCDs(10001)
GetCDs(39001)

# Calculate the distance between two centroids (eastings and northings)
NGRDist(i = c(381355, 839183), j = c(462899, 187850))

}
\author{
Anthony Hammond
}
