% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/completed_series.R
\name{completed_series}
\alias{completed_series}
\title{Complete the tracking of cycle in a wavelet spectra}
\usage{
completed_series(
  wavelet = NULL,
  tracked_curve = NULL,
  period_up = 1.2,
  period_down = 0.8,
  extrapolate = TRUE,
  genplot = FALSE,
  keep_editable = FALSE
)
}
\arguments{
\item{wavelet}{Wavelet object created using the \code{\link{analyze_wavelet}} function.}

\item{tracked_curve}{Traced period result from the \code{track_period_wavelet} function.}

\item{period_up}{The period_up parameter is the factor with which the linear interpolated tracked_curve
curve is multiplied by. This linear interpolated tracked_curve multiplied by the period_up factor is
the upper boundary which is used  for detecting the spectral peak nearest to the linear interpolated tracked_curve
curve. If no spectral peak is detected within the specified boundary the interpolated
value is used instead. between spectral peaks \code{Default=1.2},}

\item{period_down}{The period_down parameter is the factor with which the linear interpolated tracked_curve
curve is multiplied by. This linear interpolated tracked_curve multiplied by the period_down factor is
the lower boundary which is used  for detecting the spectral peak nearest to the linear interpolated tracked_curve
curve. If no spectral peak is detected within the specified boundary the interpolated
value is used instead. between spectral peaks \code{Default=0.8},}

\item{extrapolate}{Extrapolate the completed curve when through parts where no spectral peaks could be traced
\code{Default=TRUE}.}

\item{genplot}{Generate a plot \code{Default=TRUE}. The red curve is the completed curve,
the black curve is the original curve.}

\item{keep_editable}{Keep option to add extra features after plotting  \code{Default=FALSE}}
}
\value{
Returns a matrix with 2 columns
The first column is the depth axis
The second column is the completed tracking of the period a cycle of the wavelet spectra
}
\description{
Use the traced series and the existing wavelet
spectra to complete the tracking of a cycle of the wavelet spectra.
The selected points using the \code{\link{track_period_wavelet}} function form a incomplete line
unless every point is tracked. However clicking every individual point along a wavelet ridge is time
intensive and error prone.
To avoid errors and save time the \code{\link{completed_series}} function can be used to
complete the tracing of a cycle in a wavelet spectra.The \code{\link{completed_series}} function interpolates the
data points selected using the \code{\link{track_period_wavelet}}. A a search a algorithm then looks up and replaces
the interpolated curve values with the values of the nearest spectral peak in the wavelet spectra.
}
\examples{
\donttest{
#Use the grey_track example points to complete the tracking of the
# precession cycle in the wavelet spectra of the grey scale data set
# of Zeeden et al., (2013).



grey_wt <-
 analyze_wavelet(
   data = grey,
   dj = 1/200,
   lowerPeriod = 0.02,
   upperPeriod = 256,
   verbose = FALSE,
   omega_nr = 8
 )

#The ~22kyr precession cycle is between 0.25 and 1m The grey_track data
#set is a pre-loaded uncompleted tracking of the precession cycle

#grey_track <- track_period_wavelet(
#astro_cycle = 22,
#wavelet = NULL,
#n.levels = 100,
#periodlab = "Period (meters)",
#x_lab = "depth (meters)"
#)



grey_track <- completed_series(
 wavelet = grey_wt,
 tracked_curve  = grey_track,
 period_up  = 1.25,
 period_down  = 0.75,
 extrapolate = TRUE,
genplot = FALSE,
keep_editable=FALSE
)

}
}
