% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulateabn.R
\name{categorical_bugs}
\alias{categorical_bugs}
\alias{categorical_bugsGroup}
\title{Bugs code for Categorical response}
\usage{
categorical_bugs(
  nodename,
  nodesCatIdx,
  parentnames,
  nodesintercepts,
  parentcoefs
)

categorical_bugsGroup(
  nodename,
  nodesCatIdx,
  nodesintercepts,
  parentnames,
  parentcoefs,
  sigma,
  sigma_alpha
)
}
\arguments{
\item{nodename}{character string of response variable name.}

\item{nodesCatIdx}{integer vector of length \eqn{|K-1|} and starting at \eqn{k+1} (see Examples).}

\item{parentnames}{single character string (for one parent) or vector of characters (for multiple parent nodes) with parent node (predictor variables) names.}

\item{nodesintercepts}{overall mean of response. Parameter from fixed-effects intercept.}

\item{parentcoefs}{overall slope for each predictor (parent node) variable (fixed-effects).}

\item{sigma}{within-group variance. Parameter from random-effects residual.}

\item{sigma_alpha}{between-group variance-covariance matrix. Parameters from random-effects intercept.}
}
\value{
Bugs model returned as stdout.
}
\description{
Bugs code for Categorical response
}
\details{
The output of \code{\link[abn]{fitAbn}} with \code{method = "mle"} is based on
the output of logistic regression models fit with either \code{\link[stats]{lm}},
\code{\link[stats]{glm}}, \code{\link[lme4]{glmer}}, \code{\link[nnet]{multinom}},
\code{\link[mclogit]{mblogit}} or internal \code{irls} methods.
They all use the first factor level as reference level.
Therefore, \code{nodesCatIdx} starts with index \eqn{2} and not \eqn{1}.
\code{nodesintercepts} and \code{parentcoefs} refer to the values of
\code{(Intercept)} and \code{Estimate} of the respective model output.
Predictor names build the keys in \code{parentcoef}.
}
\section{Functions}{
\itemize{
\item \code{categorical_bugsGroup()}: Bugs code for Categorical response with varying intercept

}}
\examples{
# A -> B
# Where B is a categorical variable with 4 levels.
categorical_bugs(nodename = "b",
                 nodesCatIdx = c(2, 3, 4),
                 parentnames = "a",
                 nodesintercepts = c(2.188650, 3.133928, 3.138531),
                 parentcoefs = list("a"=c(a=1.686432, a=3.134161, a=5.052104)))
}
\seealso{
\link{makebugs} \link{simulateAbn}
}
\keyword{internal}
\keyword{utilities}
