% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/matrix.R
\name{matrix.one_hot}
\alias{matrix.one_hot}
\title{Creates a one-hot encoded matrix.}
\usage{
matrix.one_hot(mat, levels = NULL, n_threads = 1)
}
\arguments{
\item{mat}{A dense matrix, which can include factors with levels coded as non-negative integers.}

\item{levels}{Number of levels for each of the columns of \code{mat}, with \code{1} representing a quantitative feature. A factor with \code{K} levels should be represented by the numbers \code{0,1,...,K-1}.}

\item{n_threads}{Number of threads.}
}
\value{
One-hot encoded matrix. All the factor columns, with levels>1, are replaced by a collection of one-hot encoded versions (dummy matrices). The resulting matrix has \code{sum(levels)} columns.
The object is an S4 class with methods for efficient computation by adelie. Note that some of the arguments are transformed to C++ base 0 for internal use, and if the object is examined, it will reflect that.
}
\description{
Creates a one-hot encoded matrix.
}
\examples{
n <- 100
p <- 20
mat <- matrix(rnorm(n * p), n, p)
fac <- sample(0:5, n, replace = TRUE)
mat=cbind(fac,mat)
levels <- c(6, rep(1,p))
out <- matrix.one_hot(mat, levels = levels)
}
\author{
James Yang, Trevor Hastie, and  Balasubramanian Narasimhan \cr Maintainer: Trevor Hastie \href{mailto:hastie@stanford.edu}{hastie@stanford.edu}
}
