% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/glintnet.R
\name{print.glintnet}
\alias{print.glintnet}
\title{Print a summary of the glintnet path at each step along the path.}
\usage{
\method{print}{glintnet}(x, digits = max(3, getOption("digits") - 3), ...)
}
\arguments{
\item{x}{fitted glintnet object}

\item{digits}{significant digits in printout}

\item{...}{additional print arguments}
}
\value{
The matrix above is silently returned
}
\description{
Print a summary of the grpnet path at each step along the path.
}
\details{
The call that produced the object \code{x} is printed, followed by a
five-column matrix with columns \code{N_main},  \code{N_int}, \code{Df}, \verb{\%Dev} and \code{Lambda}.
The \code{N_main} column is the number of main-effect terms in the solution, and \code{N_int} the number of interaction terms. Since an interaction term implies both main effects, the former is always at least as large as the latter.
The \code{Df} column is the number of nonzero coefficients (Df is a
reasonable name only for lasso fits). \verb{\%Dev} is the percent deviance
explained (relative to the null deviance).
}
\examples{

x = matrix(rnorm(100 * 20), 100, 20)
y = rnorm(100)
fit1 = grpnet(x, glm.gaussian(y), groups = c(1:5,7,9))
print(fit1)
}
\references{
Yang, James and Hastie, Trevor. (2024) A Fast and Scalable Pathwise-Solver for Group Lasso
and Elastic Net Penalized Regression via Block-Coordinate Descent. arXiv \doi{10.48550/arXiv.2405.08631}.
}
\seealso{
\code{grpnet}, \code{predict}, \code{plot} and \code{coef} methods.
}
