% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/derive_param_extreme_record.R
\name{records_source}
\alias{records_source}
\title{Create a \code{records_source} Object}
\usage{
records_source(dataset_name, filter = NULL, new_vars)
}
\arguments{
\item{dataset_name}{The name of the source dataset

The name refers to the dataset provided by the \code{source_datasets} argument
of \code{derive_param_extreme_record()}.

\describe{
\item{Default value}{none}
}}

\item{filter}{An unquoted condition for selecting the observations from
\code{dataset}.

\describe{
\item{Default value}{\code{NULL}}
}}

\item{new_vars}{Variables to add

The specified variables from the source datasets are added to the output
dataset. Variables can be renamed by naming the element, i.e., \verb{new_vars = exprs(<new name> = <old name>)}.

For example \code{new_vars = exprs(var1, var2)} adds variables \code{var1} and \code{var2}
from to the input dataset.

And \code{new_vars = exprs(var1, new_var2 = old_var2)} takes \code{var1} and
\code{old_var2} from the source dataset and adds them to the input dataset renaming
\code{old_var2} to \code{new_var2}. Expressions can be used to create new variables
(see for example \code{new_vars} argument in \code{derive_vars_merged()}).

\describe{
\item{Permitted values}{list of expressions created by \code{exprs()}, e.g.,
\code{exprs(ADT, desc(AVAL))}}
\item{Default value}{none}
}}
}
\value{
An object of class \code{records_source}
}
\description{
The \code{records_source} object is used to find extreme records of interest.
}
\seealso{
\code{\link[=derive_param_extreme_record]{derive_param_extreme_record()}}

Source Objects: 
\code{\link{basket_select}()},
\code{\link{censor_source}()},
\code{\link{death_event}},
\code{\link{event}()},
\code{\link{event_joined}()},
\code{\link{event_source}()},
\code{\link{flag_event}()},
\code{\link{query}()},
\code{\link{tte_source}()}
}
\concept{source_specifications}
\keyword{source_specifications}
