% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/roclet_rdx.R
\name{execute_example}
\alias{execute_example}
\title{Execute Example Code}
\usage{
execute_example(code, expected_cnds = NULL, env = caller_env())
}
\arguments{
\item{code}{The example code

The code is expected to be a character vector of R code lines.

\describe{
\item{Permitted values}{A character vector}
\item{Default value}{none}
}}

\item{expected_cnds}{Expected conditions

\describe{
\item{Permitted values}{A character vector}
\item{Default value}{\code{NULL}}
}}

\item{env}{The environment in which to evaluate the example code

\describe{
\item{Permitted values}{An environment}
\item{Default value}{\code{caller_env()}}
}}
}
\value{
A character vector of the input code and the output and messages
created by the code. Output and messages are prefixed by \code{"#>"}.
}
\description{
This function executes the example code and captures the output and messages.
If the example code issues an unexpected message, an error is issued.
}
\keyword{internal}
\section{Examples}{
\subsection{Execute Example Code}{

\if{html}{\out{<div class="sourceCode r">}}\preformatted{admiraldev:::execute_example("1 + 1")
#> [1] "1 + 1\n#> [1] 2"

admiraldev:::execute_example("log(-1)")
#> Error in capture_output(!!expr$expr, srcref = srcref, expected_cnds = expected_cnds,  : 
#>   The expression
#> > log(-1)
#> issued an unexpected condition:
#> NaNs produced
#> If this is expected, add any of the classes "simpleWarning", "warning", and
#> "condition" to the argument `expected_cnds`.

admiraldev:::execute_example("log(-1)", expected_cnds = "warning")
#> [1] "log(-1)\n#> [1] NaN\n#> Warning in log(-1) : NaNs produced"}\if{html}{\out{</div>}}}}

