% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/crt.R
\name{SpilloverCRTpower}
\alias{SpilloverCRTpower}
\title{Conduct power analysis of conditional randomization test}
\usage{
SpilloverCRTpower(
  D,
  Z,
  CourtEvent_HearingDate,
  n = 4,
  m = 4,
  size = 2,
  cand_omegaZtilde = seq(-1.5, 1.5, by = 0.5)
)
}
\arguments{
\item{D}{A numeric vector of judge's decision.}

\item{Z}{A numeric vector of treatment variable.}

\item{CourtEvent_HearingDate}{The court event hearing date.}

\item{n}{Number of permutations.}

\item{m}{Number of permutations.}

\item{size}{The number of parallel computing. The default is \code{2}.}

\item{cand_omegaZtilde}{Candidate values}
}
\value{
A \code{data.frame} of the result of power analysis.
}
\description{
See S3.2 for more details.
}
\examples{
\donttest{
data(synth)
data(hearingdate_synth)
crt_power <- SpilloverCRTpower(D = synth$D, Z = synth$Z, 
                               CourtEvent_HearingDate = hearingdate_synth,
                               size = 1) # adjust the size
}

}
