## ----include = FALSE----------------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>",
  eval = identical(tolower(Sys.getenv("NOT_CRAN")), "true"),
  out.width = "100%"
)

## ----message = FALSE, eval = TRUE---------------------------------------------
# load libraries
library(aopdata)
library(data.table)
library(ggplot2)
library(sf)
library(scales)


## ----message = FALSE, eval = TRUE---------------------------------------------

# download aop data
df <- read_population(city='Fortaleza',
                      year=2010,
                      geometry = TRUE,
                      showProgress = FALSE)


## ----message = FALSE, eval = TRUE---------------------------------------------
ggplot() +
  geom_sf(data=subset(df, P001>0), aes(fill=P001), color=NA, alpha=.8) +
  scale_fill_distiller(palette = "YlOrRd", direction = 1)+
  labs(title='Population distribution', fill="Total population") +
  theme_void()


## ----message = FALSE, eval = TRUE---------------------------------------------
ggplot() +
  geom_sf(data=subset(df, !is.na(R002)), aes(fill=factor(R003)), color=NA, alpha=.8) +
  scale_fill_brewer(palette = "RdBu") +
  labs(title='Average household income per capita', fill="Income decile") +
  theme_void()


## ----message = FALSE, eval = TRUE---------------------------------------------
df$prop_black <- df$P003 / df$P001
  
ggplot() +
  geom_sf(data=subset(df, P001 >0), aes(fill=prop_black), color=NA, alpha=.8) +
  scale_fill_distiller(palette = "RdPu", direction = 1, labels = percent)+
  labs(title='Proportion of black population', fill="Black population") +
  theme_void()


