% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/expct.R
\name{expct}
\alias{expct}
\title{Expected Value}
\usage{
expct(params, query = NULL, evidence = NULL)
}
\arguments{
\item{params}{Circuit parameters learned via \code{\link{forde}}.}

\item{query}{Optional character vector of variable names. Estimates will be
computed for each. If \code{NULL}, all variables other than those in
\code{evidence} will be estimated.}

\item{evidence}{Optional set of conditioning events. This can take one of
three forms: (1) a partial sample, i.e. a single row of data with some but
not all columns; (2) a data frame of conditioning events, which allows for
inequalities; or (3) a posterior distribution over leaves. See Details.}
}
\value{
A one row data frame with values for all query variables.
}
\description{
Compute the expectation of some query variable(s), optionally conditioned
on some event(s).
}
\details{
This function computes expected values for any subset of features, optionally
conditioned on some event(s).
}
\examples{
# Train ARF and corresponding circuit
arf <- adversarial_rf(iris)
psi <- forde(arf, iris)

# What is the expected value Sepal.Length?
expct(psi, query = "Sepal.Length")

# What if we condition on Species = "setosa"?
evi <- data.frame(Species = "setosa")
expct(psi, query = "Sepal.Length", evidence = evi)

# Compute expectations for all features other than Species
expct(psi, evidence = evi)


}
\references{
Watson, D., Blesch, K., Kapar, J., & Wright, M. (2023). Adversarial random
forests for density estimation and generative modeling. In \emph{Proceedings
of the 26th International Conference on Artificial Intelligence and
Statistics}, pp. 5357-5375.
}
\seealso{
\code{\link{adversarial_rf}}, \code{\link{forde}}, \code{\link{lik}}
}
