% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/t_dm_slide.R
\name{gt_t_dm_slide}
\alias{gt_t_dm_slide}
\title{Demographic table with gtsummary}
\usage{
gt_t_dm_slide(adsl, arm = "TRT01P", vars = c("AGE", "SEX", "RACE"))
}
\arguments{
\item{adsl}{ADSL data set, dataframe}

\item{arm}{Arm variable, character, "`TRT01P" by default.}

\item{vars}{Characters of variables}
}
\value{
gtsummary object
}
\description{
Demographic table with gtsummary
}
\note{
* Default arm variables are set to `"TRT01A"` for safety output, and
 `"TRT01P"` for efficacy output
}
\examples{
library(dplyr)
adsl <- eg_adsl
out1 <- gt_t_dm_slide(adsl, "TRT01P", c("SEX", "AGE", "RACE", "ETHNIC", "COUNTRY"))
print(out1)
generate_slides(out1, paste0(tempdir(), "/dm.pptx"))

}
